-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `username`           varchar(32)  NOT NULL COMMENT '用户账号名称',
    `last_name`          varchar(256)  DEFAULT NULL COMMENT '用户姓氏',
    `first_name`         varchar(256)  DEFAULT NULL COMMENT '用户名称',
    `mobile`             varchar(16)   DEFAULT NULL COMMENT '用户手机号码',
    `email`              varchar(32)   DEFAULT NULL COMMENT '用户邮箱地址',
    `password`           varchar(128) NOT NULL COMMENT '用户账号密码-hashed',
    `source_type`        varchar(32)   DEFAULT NULL COMMENT '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    `enabled`            int(11)       DEFAULT NULL COMMENT '是否启用',
    `trans_flag`         int(11)       DEFAULT '0' COMMENT '是否同步 0 未同步 1 已同步',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)       DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    `need_reset`         int(11)       DEFAULT NULL COMMENT '密码是否需要重新设置',
    `wx_openid`          varchar(128)  DEFAULT NULL COMMENT '微信poenid',
    `ou_id`              bigint(20)    DEFAULT NULL COMMENT '用户所属公司ID',
    `ou_code`            varchar(40)   DEFAULT NULL COMMENT '用户所属公司编号',
    `ou_name`            varchar(40)   DEFAULT NULL COMMENT '用户所属公司名称',
    `bu_id`              bigint(20)    DEFAULT NULL COMMENT '用户所属组织ID',
    `avatar_url`         varchar(2048) DEFAULT NULL COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`        varchar(32)   DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `full_name`          varchar(40)   DEFAULT NULL COMMENT '用户姓名',
    `user_type`          varchar(40)   DEFAULT NULL COMMENT '用户类型',
    `tenant_name`        varchar(65)   DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `UK_51bvuyvihefoh4kp5syh2jpi4` (`username`) USING BTREE,
    KEY `create_user_id_index` (`create_user_id`) USING BTREE,
    KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
    KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    KEY `idx_sys_user_mobile` (`mobile`) USING BTREE
) COMMENT ='系统用户账号表';

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_permission`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `code`               varchar(128) NOT NULL COMMENT '权限代码',
    `name`               varchar(64)  NOT NULL COMMENT '权限名称',
    `perm_type`          int(11)      DEFAULT NULL COMMENT '权限类型',
    `parent_id`          bigint(20)   DEFAULT NULL COMMENT '父权限ID',
    `path`               varchar(255) DEFAULT NULL COMMENT '权限层级路径',
    `perm_level`         int(11)      DEFAULT NULL COMMENT '权限层级',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排列顺序',
    `pattern`            varchar(255) DEFAULT NULL COMMENT 'URL路径模式',
    `http_method`        varchar(32)  DEFAULT NULL COMMENT 'URL的HTTP方法[COM:HTTP_METH]',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `icon`               varchar(255) DEFAULT NULL COMMENT '菜单图标',
    `is_hidden`          int(11)      DEFAULT NULL COMMENT '菜单是否隐藏',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `create_user_id_index` (`create_user_id`) USING BTREE,
    KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
    KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    KEY `idx_sys_permission_pid` (`parent_id`)
) COMMENT ='系统权限表，包括URL、操作';

-- ----------------------------
-- Table structure for sys_tenant
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant`
(
    `id`                 bigint(20)       NOT NULL COMMENT '记录唯一ID',
    `tenant_code`        varchar(255)     NOT NULL COMMENT '租户编码',
    `tenant_name`        varchar(255)     NOT NULL COMMENT '租户名称',
    `sys_user_id`        bigint(20)       NOT NULL COMMENT '管理员的用户ID',
    `admin_account`      varchar(255)     NOT NULL COMMENT '管理员的登录账号',
    `tenant_type`        varchar(225)     NOT NULL COMMENT '租户类型',
    `enabled`            tinyint(1)       NOT NULL DEFAULT '0' COMMENT '是否启用',
    `linkman`            varchar(255)              DEFAULT NULL COMMENT '联系人',
    `contact_number`     varchar(255)              DEFAULT NULL COMMENT '联系电话',
    `address`            varchar(255)              DEFAULT NULL COMMENT '联系地址',
    `tenant_isolation`   varchar(32)      NOT NULL COMMENT '租户数据隔离',
    `db_initialized`     tinyint(1)       NOT NULL DEFAULT '0' COMMENT '数据库是否已初始化',
    `database_source_id` bigint(20)                DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`        varchar(255)     NOT NULL DEFAULT '' COMMENT 'schema名称，如果租户数据隔离通过schema',
    `tenant_domain`      varchar(256)              DEFAULT NULL COMMENT '域名地址',
    `custom_domain`      varchar(400)              DEFAULT NULL COMMENT '租户自定义域名',
    `tenant_id`          bigint(20)                DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)              DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)                DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)              DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)               DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)                DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)              DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)               DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10) unsigned NOT NULL DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)                   DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)                DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)                DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)                DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_sys_tenant_code` (`tenant_code`) USING BTREE
) COMMENT ='平台租户表';

-- ----------------------------
-- Table structure for sys_tenant_db_migrate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_db_migrate`
(
    `id`                  bigint(20)       NOT NULL COMMENT '主键ID',
    `sys_tenant_id`       bigint(20)       NOT NULL COMMENT '租户ID',
    `app_code`            varchar(255)     NOT NULL COMMENT '应用编码',
    `tenant_isolation`    varchar(32)      NOT NULL COMMENT '租户数据隔离',
    `database_source_id`  bigint(20)                DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`         varchar(255)     NOT NULL DEFAULT '' COMMENT 'schema名称，如果租户数据隔离通过schema',
    `migrate_success`     tinyint(1)       NOT NULL DEFAULT '0' COMMENT '是否迁移成功',
    `migrate_start_time`  datetime                  DEFAULT NULL COMMENT '迁移开始时间',
    `migrate_finish_time` datetime                  DEFAULT NULL COMMENT '迁移结束时间',
    `fail_reason`         text COMMENT '更新失败原因',
    `tenant_id`           bigint(20)                DEFAULT NULL COMMENT '租户ID',
    `remark`              varchar(255)              DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(20)                DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255)              DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)               DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(20)                DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255)              DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)               DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(10) unsigned NOT NULL DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`  int(11)                   DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(20)                DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`         bigint(20)                DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`           bigint(20)                DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tenant_db_migrate_tenant_id` (`sys_tenant_id`) USING BTREE
) COMMENT ='租户数据库的创建记录';

-- ----------------------------
-- Table structure for sys_tenant_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_tenant_user`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_user_id`        bigint(20) NOT NULL COMMENT '用户ID',
    `sys_tenant_id`      bigint(20) NOT NULL COMMENT '租户ID',
    `bind_time`          datetime   NOT NULL COMMENT '绑定时间',
    `last_login_time`    datetime     DEFAULT NULL COMMENT '上次登录时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_tenant_user_user_id` (`sys_user_id`) USING BTREE,
    KEY `idx_tenant_user_tenant_id` (`sys_tenant_id`) USING BTREE
) COMMENT ='用户与租户的绑定关系';

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `undo_log`
(
    `id`            bigint(20)   NOT NULL AUTO_INCREMENT COMMENT 'increment id',
    `branch_id`     bigint(20)   NOT NULL COMMENT 'branch transaction id',
    `xid`           varchar(128) NOT NULL COMMENT 'global transaction id',
    `context`       varchar(128) NOT NULL COMMENT 'undo_log context,such as serialization',
    `rollback_info` longblob     NOT NULL COMMENT 'rollback info',
    `log_status`    int(11)      NOT NULL COMMENT '0:normal status,1:defense status',
    `log_created`   datetime     NOT NULL COMMENT 'create datetime',
    `log_modified`  datetime     NOT NULL COMMENT 'modify datetime',
    PRIMARY KEY (`id`),
    UNIQUE KEY `ux_undo_log` (`xid`, `branch_id`)
) COMMENT ='AT transaction mode undo table';

-- ----------------------------
-- Table structure for sys_user_proxy
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_proxy`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '被代理人id',
    `username`           varchar(32) NOT NULL COMMENT '被代理人用户账号名称',
    `mobile`             varchar(16)  DEFAULT NULL COMMENT '被代理人用户手机号码',
    `email`              varchar(32)  DEFAULT NULL COMMENT '被代理人用户邮箱地址',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '被代理人用户所属公司ID',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '被代理人用户所属公司编号',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '被代理人用户所属公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT '被代理人用户所属组织ID',
    `proxy_user_id`      bigint(20)   DEFAULT NULL COMMENT '代理人id',
    `proxy_username`     varchar(32) NOT NULL COMMENT '代理人用户账号名称',
    `proxy_mobile`       varchar(16)  DEFAULT NULL COMMENT '代理人用户手机号码',
    `proxy_email`        varchar(32)  DEFAULT NULL COMMENT '代理人用户邮箱地址',
    `proxy_ou_id`        bigint(20)   DEFAULT NULL COMMENT '代理人用户所属公司ID',
    `proxy_ou_code`      varchar(40)  DEFAULT NULL COMMENT '代理人用户所属公司编号',
    `proxy_ou_name`      varchar(40)  DEFAULT NULL COMMENT '代理人用户所属公司名称',
    `proxy_bu_id`        bigint(20)   DEFAULT NULL COMMENT '代理人用户所属组织ID',
    `open_flag`          int(11)      DEFAULT NULL COMMENT '是否开启-0：开启，1关闭',
    `effect_start_time`  datetime(6)  DEFAULT NULL COMMENT '代理生效开始时间',
    `effect_end_time`    datetime(6)  DEFAULT NULL COMMENT '代理生效结束时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_asmyoj2xbixiyvpymex71uihg` (`username`) USING BTREE,
    UNIQUE INDEX `UK_al4cbi2jpu3dc3128lomq2s88` (`proxy_username`) USING BTREE
) COMMENT = '被代理用户与代理用户关系表';

-- ----------------------------
-- Table structure for sys_data_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_data_role`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(40) NOT NULL COMMENT '数据角色代码',
    `name`               varchar(40) NOT NULL COMMENT '数据角色名称',
    `advanced_enable`    int(11)     NOT NULL COMMENT '是否取用高级授权',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `business_enable`    int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_cem7cq6iwip27be1ik1724rtq` (`code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统数据角色表';

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role`
(
    `id`                 bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_name`        varchar(64)  DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `UK_plpigyqwsqfn7mn66npgf9ftp` (`code`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统角色表';

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_role`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '用户ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `idx_sys_user_role_role_id` (`role_id`) USING BTREE,
    INDEX `idx_sys_user_role_user_id` (`user_id`) USING BTREE
) COMMENT = '用户角色关联表';

-- ----------------------------
-- Table structure for sys_user_terminal
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_terminal`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)  NOT NULL COMMENT '用户ID，sys_user.id',
    `terminal_code`      varchar(64) NOT NULL COMMENT '终端编码，Terminal枚举类',
    `time_bind`          datetime     DEFAULT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_terminal_user` (`user_id`) USING BTREE
) COMMENT = '用户与终端的关联';

-- ----------------------------
-- Table structure for sys_user_data_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_data_role`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '用户数据角色关联表';

-- ----------------------------
-- Table structure for sys_flow_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_flow_role`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_k7iim1lyhuyr06xn6jdj8vei1` (`code`) USING BTREE
) COMMENT = '流程角色表';

-- ----------------------------
-- Table structure for sys_user_flow_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_flow_role`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '用户流程角色关联表';